#define LOAD_FONT4
#include <M5Stack.h>
#include <BLEDevice.h>
#include <BLEServer.h>

//BLE関連
//デバイス名
const char *DEVICE_NAME = "m5-stack-ble-midi";

//BLE MIDIのサービスとキャラクタラスティック
const char *SERVICE_UUID = "03B80E5A-EDE8-4B33-A751-6CE34EC4C700";
const char *CHAR_UUID = "7772E5DB-3868-4112-A1A9-F2669D106BF3";

//BLEデータ
BLEServer *pServer;
BLECharacteristic *pCharacteristic;
bool isConnected = false;

//BLE MIDIデータ
unsigned char buff[] = {0x80, 0x80, 0xB0, 0x01, 0x64};

//ボタンBuff
bool pressed[3];

//BLE関連関数
// サーバーのコールバック関数
class cbServer: public BLEServerCallbacks {
  void onConnect(BLEServer *pServer) {
    isConnected = true;
    M5.Lcd.clear(); 
    M5.Lcd.drawCentreString(" BLE Connected  ", 160, 120, 4);
  };

  void onDisconnect(BLEServer *pServer) {
    isConnected = false;
    M5.Lcd.clear(); 
    M5.Lcd.drawCentreString(DEVICE_NAME, 160, 120, 4);
  }
};

//MIDI関連関数
//BLE Noteを送信
void notifyNote(int note, int velocity)
{    
  //noteをvelcityの強さで送信
  buff[2] = 0x90;
  buff[3] = note;      
  buff[4] = velocity;

  //MIDIデータをNotify
  pCharacteristic->setValue(buff, 5);
  pCharacteristic->notify();    
}

void setup(){
  int i;
  
  // M5Stackの初期化
  M5.begin();

  //Btnバッファの初期化
  for(i = 0; i < 2; i++)
  {
    pressed[i] = false;
  }

  // BLE初期化
  BLEDevice::init(DEVICE_NAME);

  // サーバーの作成
  BLEServer *pServer = BLEDevice::createServer();
  // コールバック関数の設定
  pServer->setCallbacks(new cbServer());

  // サービスの作成
  BLEService *pService = pServer->createService(SERVICE_UUID);

  // キャラクタリスティックの作成
  pCharacteristic = pService->createCharacteristic(
    CHAR_UUID,
    BLECharacteristic::PROPERTY_READ | BLECharacteristic::PROPERTY_NOTIFY
  );
  
  // サービスの開始
  pService->start();

  //アドバタイジングの開始    
  pServer->getAdvertising()->addServiceUUID(SERVICE_UUID);
  pServer->getAdvertising()->start();

  //ディスプレイにデバイスネームを表示
  M5.Lcd.drawCentreString("m5-stack-ble-midi", 160, 120, 4);
}

void loop() {
  if (isConnected)
  {
    //BtnAを押したらC Note On
    if(M5.BtnA.read() && !pressed[0])
    {
      pressed[0] = true;
      notifyNote(60, 100);
    }
    //BtnAを離したらC Note Off
    else if(!M5.BtnA.read() && pressed[0])
    {
      pressed[0] = false;
      notifyNote(60, 0);      
    }

    //BtnBを押したらE Note On
    if(M5.BtnB.read() && !pressed[1])
    {
      pressed[1] = true;
      notifyNote(64, 100);
    }
    //BtnBを離したらE Note Off
    else if(!M5.BtnB.read() && pressed[1])
    {
      pressed[1] = false;
      notifyNote(64, 0);      
    }
    
    //BtnCを押したらE Note On
    if(M5.BtnC.read() && !pressed[2])
    {
      pressed[2] = true;
      notifyNote(67, 100);
    }
    //BtnBを離したらE Note Off
    else if(!M5.BtnC.read() && pressed[2])
    {
      pressed[2] = false;
      notifyNote(67, 0);      
    }        
    M5.update();
  }
}
